<?php
/***************************************************************\
 *  ArchiveWidget plugin pour Dotclear 2                       *
 *  Keul <keul at keul dot fr>                                 *
 *  Licence GNU GPL v2                                         *
\***************************************************************/
if (!defined('DC_RC_PATH')) { return; }

require dirname(__FILE__).'/_widgets.php';

class publicMyArchiveWidget {
	public static function myArchiveWidget($w) {
		global $core;
		if (($w->homeonly == 1 && $core->url->type != 'default') ||
			($w->homeonly == 2 && $core->url->type == 'default')) {
			return;
		}
		$params = array();
		$params['type'] = 'month';
		$params['post_type'] = 'post';
		$params['order'] = 'desc';
		$archives = $core->blog->getDates($params);
		unset($params);
		
		//titre
		$header='<h2>'.sprintf($w->title,$core->blog->url.$core->url->getBase("archive")).'</h2>';
		
		$out='<ul>';
		
		while ($archives->fetch()) {
			//début année
			if ($archives->yearHeader()) {
			$out.='<li>'.sprintf($w->year,dt::dt2str('%Y',$archives->dt)).'<ul>';
			}
			//liste mois
			$out.='<li>'.sprintf($w->month,$archives->url($core),dt::dt2str('%Y',$archives->dt),dt::dt2str('%B',$archives->dt),$archives->nb_post).'</li>';
			//fin année
			if ($archives->yearFooter()) {
				$out.='</ul></li>';
			}
		}
		$archives = null;
		return $res = ($w->content_only ? '' : '<div class="archive-widget'.($w->class ? ' '.html::escapeHTML($w->class) : '').'">').$header.
    $out.'</ul>'.
    ($w->content_only ? '' : '</div>');
	}
}
?>