<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of customiz, a plugin for Dotclear 2.
# 
# Copyright (c) 2012 Osku and contributors
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_CONTEXT_ADMIN')) { return; }

dcPage::check('admin');

$head_title = __('My customizations');
$page_title = '<span class="page-title">'.__('My customizations').'</span>';

$edit_mode = false;
$custom_message = '';
$custom_name = '';
$settings =& $core->blog->settings->customiz;

$behaviors_combo  = array();
$behaviors_combo[__('default templates')] = array(
    __('Content afer top') => 'publicTopAfterContent',
    __('Footer content') => 'publicFooterContent',
    __('Content before comment form') => 'publicCommentFormBeforeContent' ,
    __('Content after comment form') => 'publicCommentFormAfterContent' 
    );
    
$behaviors_combo[__('agora templates')] = array(
    __('Content before register form') => 'publicRegisterFormBefore',
    __('Content after register form') => 'publicRegisterFormAfter',
    __('Content before login form') => 'publicLoginFormBefore',
    __('Content after login form') => 'publicLoginFormAfter',
    __('Content before password recover form') => 'publicRecoverFormBefore' ,
    __('Content after password recover form') => 'publicRecoverFormAfter' ,
    __('Content before preferences form') => 'publicPreferencesFormBefore' ,
    __('Content after preferences form') => 'publicPreferencesFormAfter',
    __('Content before mail form') => 'publicMailtoFormBefore',
    __('Content after mail form') => 'publicMailtoFormAfter' ,
    __('Content before new entry form') => 'publicEntryFormBefore' ,
    __('Content after new entry form') => 'publicEntryFormAfter',
    __('Content before new message form') => 'publicMessageFormBeforeContent',
    __('Content after new message form') => 'publicMessageFormAfterContent',
    __('Content before entry edition form') => 'publicEditEntryFormBefore',
    __('Content after entry edition form') => 'publicEditEntryFormAfter',
    __('Content before message edition form') => 'publicEditMessageFormBefore',
    __('Content after message edition form') => 'publicEditMessageFormAfter',
    __('Content before user files form') => 'publicMediaFormBefore' ,
    __('Content after user files form') => 'publicMediaFormAfter'
);

$label_behaviors =
    array_merge(
        array_flip($behaviors_combo[__('default templates')]),
        array_flip($behaviors_combo[__('agora templates')])
    );

if (!empty($_REQUEST['current'])) {
	$edit_mode = true;
	$custom_name = $_REQUEST['current'];
	$current_url = $p_url.'&current='.$custom_name;
	$page_title = '<a href="'.$p_url.'">'.__('My customizations').'</a>
			&rsaquo; <span class="page-title">'.$label_behaviors[$custom_name].'</span>';
}

if (!empty($_POST['behaviorname']) && !empty($_POST['add_field'])) {
	http::redirect($p_url.'&current='.$_POST['behaviorname']);
}

if (!empty($_REQUEST['current']) && !empty($_POST['save_field'])) {
	$settings->put($custom_name,$_POST['custom_message'],'string');
	http::redirect($p_url.'&message=save&current='.$_POST['behaviorname']);
}

if (!empty($_REQUEST['remove'])) {
	$settings->drop($_REQUEST['remove']);
	http::redirect($p_url.'&message=remove');
}

$custom_message = $settings->{$custom_name};

$params = array( 'ns' => 'customiz','blog_id' => $core->blog->id);
$custom_behaviors = $core->blog->settings->getGlobalSettings($params);

$msg = isset($_REQUEST['message']) ? $_REQUEST['message'] : '';
$msg_list = array(
	'save' => __('Customization has been successfully saved.'),
	'remove' => __('Customisation has been successfully removed.')
);

if (isset($msg_list[$msg])) {
	#$msg = sprintf('<p class="message">%s</p>',$msg_list[$msg]);
    $msg = dcPage::message($msg_list[$msg]);
}
?>
<html>
<head>
	<title><?php echo $head_title; ?></title>
	<?php echo  dcPage::jsToolBar();?>
	<script type="text/javascript">
	//<![CDATA[
	$(function() {
		var tbCustomMessage=new jsToolBar(document.getElementById('custom_message'));
		tbCustomMessage.draw('xhtml');
	});
	//]]>
	</script>
</head>
<body>
<?php
echo $msg.
'<h2>'.html::escapeHTML($core->blog->name).' &rsaquo; '.$page_title.'</h2>';
if (!$edit_mode) 
{
	if (!$custom_behaviors->isEmpty())
	{
		echo '<h3>'.__('Customizations list').'</h3>';
		echo '<ul>';
		while ($custom_behaviors->fetch())
		{
			echo 
				'<li><a class="button" 
					href="'.$p_url.'&current='.$custom_behaviors->setting_id.'" 
					title="'.html::clean($custom_behaviors->setting_value).'&nbsp;('.__('Clic to modify').')">
					'.$label_behaviors[$custom_behaviors->setting_id].'
					</a>
					&nbsp;&ndash;&nbsp;
					<a 
					href="'.$p_url.'&remove='.$custom_behaviors->setting_id.'" 
					title="'.__('Delete').'">
					'.__('Delete').' <img src="images/trash.png"/>
					</a>
				</li>';
		}
		echo '</ul>';
	}
	
	echo
		'<form action="'.$p_url.'" method="post" id="add-custom">
		<p><label for="filename" class="classic required">
			<abbr title="'.__('Required field').'">*</abbr>
			'.__('Area to customize:').' '.
			form::combo('behaviorname',$behaviors_combo).'</label>
		</p>
		<p>'.form::hidden(array('p'),'customiz').
		$core->formNonce().
		'<input type="submit" name="add_field" value="'.__('Initialize').'" />
		</p>
		</form>';
} else {
	echo
		'<form action="'.$current_url.'" method="post" id="modify-custom">
		<p class="area"><label for="custom_message">
			'.__('Content:').'</label>'.
			form::textarea('custom_message',40,10,html::escapeHTML($custom_message)).
		'</p>
		<p>'.form::hidden(array('p'),'customiz').
		form::hidden(array('behaviorname'),$custom_name).
		$core->formNonce().
		'<input type="submit" name="save_field" value="'.__('Save').'" />
		</p>
		</form>';
}
?>
</body>
</html>