<?php

// Security test
if (!defined('DC_CONTEXT_ADMIN')) { return; }
 
// Version check
$m_version = $core->plugins->moduleInfo('dotpoll','version');
$i_version = $core->getVersion('dotpoll');
if (version_compare($i_version,$m_version,'>=')) {
    // Nothing to do
	return;
}

// DB Update
$s = new dbStruct($core->con,$core->prefix);

$s->dotpoll
    ->poll_id('integer',0,false) // Type, long, possible null, défaut
    ->poll_title('varchar',255,true)
    ->poll_blog('varchar',255,true)
    ->poll_status('smallint',0,false)
    ->poll_user('varchar',32,true)
    ->poll_cdate('integer',0,false)
    ;
$s->dotpoll->primary($core->prefix.'dotpoll','poll_id');
$s->dotpoll_result
    ->result_id('integer',0,false)
    ->result_poll_id('integer',0,false)
    ->result_option_id('integer',0,false)
    ->result_user_ip('varchar',25,false)
    ;
$s->dotpoll_result->primary($core->prefix.'dotpoll_result','result_id');
$s->dotpoll_option
    ->option_id('integer',0,false)
    ->option_poll_id('integer',0,false)
    ->option_text('varchar',255,true)
    ->option_position('integer',0,false)
    ;
$s->dotpoll_option->primary($core->prefix.'dotpoll_option','option_id');

$si = new dbStruct($core->con,$core->prefix);
$changes = $si->synchronize($s);

// Settings
$settings = new dcSettings($core,null);
$settings->setNamespace('dotpoll');
$settings->put('dotpoll_cookie_id',true,'boolean','Enable cookie identification');
$settings->put('dotpoll_ip_id',false,'boolean','Enable IP identification');

// Define current version
$core->setVersion('dotpoll',$m_version);

// Installation success
return true;
?>
