<?php
class dcDotpollWidget
{
        public static function initWidget(&$w)
        {
            global $core;
            $manager = new dcDotpolls($core);
            $manager->addFilter('poll_status',1);

            try
            {
                  $polls = $manager->getPolls();
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  return __('Error: ').$e->getMessage();
            }
            $combo = array();
            foreach($polls as $poll)
                  $combo[$poll->title] = html::escapeHTML($poll->id);

            $w->create('dotpoll',__('DotPoll'),array('dcDotpollWidget','showWidget'));
            $w->dotpoll->setting('title',__('Title:'),__('title'),'text');
            $w->dotpoll->setting('poll',__('Poll:'),null,'combo',$combo);
            $w->dotpoll->setting('homeonly',__('Home page only'),0,'check');
        }
        
        public static function showWidget(&$w)
        {
            global $core;

            if ($w->homeonly && $core->url->type != 'default') {
                  return;
            }

            $manager = new dcDotpolls($core);
            $manager->addFilter('poll_status',1);
            
            try
            {
                  $poll = $manager->getPoll($w->poll);
            }
            catch(Exception $e)
            {
                  $core->error->add($e->getMessage());
                  return __('Error: ').$e->getMessage();
            }

            if(!empty($_POST['dcDotPollOption'.$w->poll]))
                  $poll->addResult($_POST['dcDotPollOption'.$w->poll]);

            $res = '<div class="dotpoll'.
	             ($poll->userHasResult()?'done':'').
		       '" id="dotpoll'.$w->poll.'">';
            if($w->title != '')
                  $res .= '<h2>'.html::escapeHTML($w->title).'</h2>';

            $res .= '<p>'.html::escapeHTML($poll->title).'</p>';
            
            if(!$poll->userHasResult() && empty($_POST['dcDotPollOption'.$w->poll]) && empty($_POST['dcDotPollResults'.$w->poll]))
            {
                  $res .= '<form action="'.http::getSelfURI().'#dotpoll'.$w->poll.'" method="post">'.
                          '<ul>';
                  foreach($poll->options as $id => $op)
                        $res .= '<li><label><input type="radio" name="dcDotPollOption'.$w->poll.'" value="'.$id.'" /> '.
                                html::escapeHTML($op).'</label></li>';
                  $res .= '</ul><p><input type="submit" name="vote" value="'.__('Vote!').'" /> '.
		  	  '<input type="submit" name="dcDotPollResults'.$w->poll.'" value="'.__('Results').'" /></p>'.
                          '</form>';
            }
            else
            {
                  $res .= '<ul>';
                  $option = $poll->options;
                  foreach($poll->results as $id => $r)
                  {
                        $res .= '<li>'.$option[$id].__(':').' <strong>'.$r['per'].' %</strong></li>';
                  }
                  $res .= '</ul>'.
                          '<p>'.__('Total votes:').' '.$poll->votes.'</p>';
            }             
            $res .= '</div>';

            return $res;
        }
}
?>
