<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of dcAdminTuning a plugin for Dotclear 2.
# 
# Copyright (c) 2011 Osku and contributors
#
# Licensed under the GPL version 2.0 license.
# A copy of this license is available in LICENSE file or at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK ------------------------------------
if (!defined('DC_CONTEXT_ADMIN')) { return; }

$config = array();
$s =& $core->blog->settings->themes;

if (isset($_POST['file_content'])) {
	try {
	// Save CSS
	$css = base64_encode($_POST['file_content']);
	$s->put('morecss',$css);
	
	// Minify it
	$css_min = preg_replace('` {2,}`', ' ', $_POST['file_content']);
	$css_min = preg_replace('/(\/\*[\s\S]*?\*\/)/', '', $css_min);
	$css_min = preg_replace('/(\t|\r|\n)/', '', $css_min);
	$css_min = str_replace(array(' { ',' {','{ '),'{', $css_min);
	$css_min = str_replace(array(' } ',' }','} '),'}', $css_min);
	$css_min = str_replace(array(' : ',' :',': '),':', $css_min);
	$css_min = str_replace(array(' ; ',' ;','; '),';', $css_min);
	$css_min = str_replace(array(' , ',' ,',', '),',', $css_min);
	$s->put('morecss_min',base64_encode($css_min));
	
	http::redirect($p_url.'&config=1');
	} catch (Exception $e) {
		$core->error->add($e->getMessage());
	}
}

$css_content = base64_decode($s->morecss);

?>
<html>
<head>
  <title><?php echo __('Style sheet'); ?></title>
  <script type="text/javascript">
  //<![CDATA[
  <?php echo dcPage::jsVar('dotclear.msg.saving_document',__("Saving document...")); ?>
  <?php echo dcPage::jsVar('dotclear.msg.document_saved',__("Document saved")); ?>
  <?php echo dcPage::jsVar('dotclear.msg.error_occurred',__("An error occurred:")); ?>
  //]]>
  </script>
  <script type="text/javascript" src="index.php?pf=moreCSS/script.js"></script>
</head>
<body>
<?php 
if (!empty($_GET['config'])) {
	dcPage::message(__('Configuration successfully updated.'));
}
echo '<h2>'.html::escapeHTML($core->blog->name).' &rsaquo; <span class="page-title">'.__('Style sheet').'</span></h2>';

echo
'<form action="'.$p_url.'" id="file-form" method="post">

<fieldset><legend>'.__('Style sheet').'</legend>
	<div><p><label for="file_content">'.__('Style sheet:').' </label>'.
		form::textarea('file_content',60,20,html::escapeHTML($css_content),'maximal').'
	</p><p>'.form::hidden('p','moreCSS').
	$core->formNonce().
	'<input type="submit" name="write" value="'.__('Save').' (s)" accesskey="s" /></p>
	</div></fieldset>
</form>';
?>
</body>
</html>