<?php
class randomPost {
	const allCatID = 'randomPostAllCat';

	private $post;
	private $blog;
	private $withContent;
	private $categoryRestrict;

	public function __construct(&$blog,$withContent=false,$category=randomPost::allCatID)
	{
		$this->post = null;
		$this->blog =& $blog;
		$this->withContent = $withContent;
		$this->categoryRestrict = $category;
	}

	protected function &getRandomPost($category)
	{
		// Get the total number of public posts in the blog
		if ($category != randomPost::allCatID) {
			$count = $this->blog->getPosts(array('cat_id'=>$category),true);
		} else {
			$count = $this->blog->getPosts(array(), true);
		}

		// Get a random number between 0 and the total number of posts minus 1
		// This gives us an offset to access a random record in the next query
		$offset = mt_rand(0, $count->f(0) - 1);

		// Get the random post, via an SQL request of type '... limit 1 offset XXX'
		$params = array('limit'=>array($offset, 1));
		if (!$this->withContent) {
			$params = array_merge($params, array('no_content'=>'1'));
		}
		if ($category != randomPost::allCatID) {
			$params = array_merge($params, array('cat_id'=>$category));
		}
		$rs = $this->blog->getPosts($params);
		return $rs;
	}

	protected function initRandomPost()
	{
		if ($this->post == null) {
			$this->post =& $this->getRandomPost($this->categoryRestrict);
		}
	}

	public function getURL()
	{
		$this->initRandomPost();
		return $this->post->getURL();
	}

	public function getPostURL()
	{
		$this->initRandomPost();
		return $this->post->getURL();
	}

	public function getPostTitle()
	{
		$this->initRandomPost();
		return $this->post->post_title;
	}

	public function &getPost()
	{
		$this->initRandomPost();
		return $this->post;
	}

}