<?php
/**
 * @version   $Id: route.php 6852 2013-01-28 18:51:50Z btowles $
 * @author    RocketTheme, LLC http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2016 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

// no direct access
defined('_JEXEC') or die;

// Component Helper
jimport('joomla.application.component.helper');
jimport('joomla.application.categories');

/**
 * Contact Component Route Helper
 *
 * @static
 * @package        Joomla.Site
 * @subpackage     com_contact
 * @since          1.5
 */
abstract class RokQuickCartHelperRoute
{
	protected static $lookup;

	/**
	 * @param    int    The route of the newsfeed
	 */
	public static function getRokQuickCartRoute($id)
	{
		$needles = array(
			'contact' => array((int)$id)
		);
		//Create the link
		$link = 'index.php?option=com_rokquickcart&view=rokquickcart&id=' . $id;

		if ($item = self::_findItem($needles)) {
			$link .= '&Itemid=' . $item;
		} elseif ($item = self::_findItem()) {
			$link .= '&Itemid=' . $item;
		}

		return $link;
	}

	protected static function _findItem($needles = null)
	{
		$app   = JFactory::getApplication();
		$menus = $app->getMenu('site');

		// Prepare the reverse lookup array.
		if (self::$lookup === null) {
			self::$lookup = array();

			$component = JComponentHelper::getComponent('com_rokquickcart');
			$items     = $menus->getItems('component_id', $component->id);
			foreach ($items as $item) {
				if (isset($item->query) && isset($item->query['view'])) {
					$view = $item->query['view'];
					if (!isset(self::$lookup[$view])) {
						self::$lookup[$view] = array();
					}
					if (isset($item->query['id'])) {
						self::$lookup[$view][$item->query['id']] = $item->id;
					}
				}
			}
		}

		if ($needles) {
			foreach ($needles as $view => $ids) {
				if (isset(self::$lookup[$view])) {
					foreach ($ids as $id) {
						if (isset(self::$lookup[$view][(int)$id])) {
							return self::$lookup[$view][(int)$id];
						}
					}
				}
			}
		} else {
			$active = $menus->getActive();
			if ($active) {
				return $active->id;
			}
		}

		return null;
	}
}
