<?php
/**
 * @brief Berlin, a theme for Dotclear 2
 *
 * @package Dotclear
 * @subpackage Themes
 *
 * @copyright Olivier Meunier & Association Dotclear
 * @copyright GPL-2.0-only
 */
declare(strict_types=1);

namespace Dotclear\Theme\Berlin_Copy;

use dcCore;
use dcNsProcess;
use dcUtils;
use Dotclear\Helper\L10n;

class Frontend extends dcNsProcess
{
    public static function init(): bool
    {
        static::$init = defined('DC_RC_PATH');

        return static::$init;
    }

    public static function process(): bool
    {
        if (!static::$init) {
            return false;
        }

        L10n::set(__DIR__ . '/../locales/' . dcCore::app()->lang . '/main');

        dcCore::app()->addBehavior('publicHeadContent', function () {
            echo
            dcUtils::jsJson('dotclear_berlin', [
                'show_menu'  => __('Show menu'),
                'hide_menu'  => __('Hide menu'),
                'navigation' => __('Main menu'),
            ]);
        });

        return true;
    }
}
